// hashChain.java
// demonstracja tablicy rozproszonej z czeniem niezalenym
// aby uruchomi program: C:>java HashChainApp (wersja angielska)
// aby skompilowa wersj polsk: C:>javac hashChain.java
// po kompilacji:         C:>java HashChainApp
import java.io.*;
////////////////////////////////////////////////////////////////
class Link
   {                                 // (moe mie wicej danych)
   private int iData;                // element danych (klucz)
   public Link next;                   // kolejny element listy
// -------------------------------------------------------------
   public Link(int it)                 // konstruktor
      { iData= it; }
// -------------------------------------------------------------
   public int getKey()
      { return iData; }
// -------------------------------------------------------------
   public void displayLink()           // wywietl element listy
      { System.out.print(iData + " "); }
   }  // end class Link
////////////////////////////////////////////////////////////////
class SortedList
   {
   private Link first;               // odwoanie do pierwszego elementu listy
// -------------------------------------------------------------
   public void SortedList()          // konstruktor
      { first = null; }
// -------------------------------------------------------------
   public void insert(Link theLink)  // wstaw element listy na odpowiedniej pozycji
      {
      int key = theLink.getKey();
      Link previous = null;          // rozpoczynamy od pierwszego elementu
      Link current = first;
                                     // a do koca listy,
      while( current != null && key > current.getKey() )
         {                           // lub biecy > klucz,
         previous = current;
         current = current.next;     // id do nastpnego elementu
         }
      if(previous==null)             // jeeli pocztek listy,
         first = theLink;            //    pierwszy = nowe cze
      else                           // jeeli nie,
         previous.next = theLink;    //    poprzedni elementczymy z nowym
      theLink.next = current;        // nowy element czymy z biecym
      }  // end insert()
// -------------------------------------------------------------
   public void delete(int key)       // usuwanie elementu listy
      {                              // (zakadamy, e lista nie jest pusta)
      Link previous = null;          // rozpoczynamy od pierwszego elementu
      Link current = first;
                                     // a do koca listy,
      while( current != null && key != current.getKey() )
         {                           // lub klucz wyszukiwany == klucz elementu,
         previous = current;
         current = current.next;     // id do nastpnego elementu
         }
                                     // odcz element
      if(previous==null)             //   jeeli pocztek listy
         first = first.next;         //      usu pierwszy element
      else                           //   jeeli nie
         previous.next = current.next; //    usu biecy element
      }  // end delete()
// -------------------------------------------------------------
   public Link find(int key)         // znajd element listy
      {
      Link current = first;          // rozpoczynamy od pierwszego elementu
                                     // a do koca listy,
      while(current != null &&  current.getKey() <= key)
         {                           // lub klucz zbyt may,
         if(current.getKey() == key)    // czy to element wyszukiwany?
            return current;          // znaleziono, zwr
         current = current.next;     // id do nastpnego elementu
         }
      return null;                   // nie znaleziono
      }  // end find()
// -------------------------------------------------------------
   public void displayList()
      {
      System.out.print("Lista (pierwszy-->ostatni): ");
      Link current = first;       // rozpoczynamy od pierwszego elementu listy
      while(current != null)      // a do koca listy,
         {
         current.displayLink();   // wywietl dane
         current = current.next;  // przejd do nastpnego elementu listy
         }
      System.out.println("");
      }
   }  // end class SortedList
////////////////////////////////////////////////////////////////
class HashTable
   {
   private SortedList[] hashArray;   // tablica list
   private int arraySize;
// -------------------------------------------------------------
   public HashTable(int size)        // konstruktor
      {
      arraySize = size;
      hashArray = new SortedList[arraySize];  // utwrz tablic
      for(int j=0; j<arraySize; j++)          // wypenij tablic
         hashArray[j] = new SortedList();     // listami
      }
// -------------------------------------------------------------
   public void displayTable()
      {
      for(int j=0; j<arraySize; j++) // dla kadej komrki,
         {
         System.out.print(j + ". "); // wywietl numer komrki
         hashArray[j].displayList(); // wywietl list
         }
      }
// -------------------------------------------------------------
   public int hashFunc(int key)      // funkcja rozpraszajca
      {
      return key % arraySize;
      }
// -------------------------------------------------------------
   public void insert(Link theLink)  // wstaw element listy
      {
      int key = theLink.getKey();
      int hashVal = hashFunc(key);   // oblicz indeks
      hashArray[hashVal].insert(theLink); // wstaw na pozycji hashVal
      }  // end insert()
// -------------------------------------------------------------
   public void delete(int key)       // usu element listy
      {
      int hashVal = hashFunc(key);   // oblicz indeks
      hashArray[hashVal].delete(key); // usu element listy
      }  // end delete()
// -------------------------------------------------------------
   public Link find(int key)         // znajd element listy
      {
      int hashVal = hashFunc(key);   // oblicz indeks
      Link theLink = hashArray[hashVal].find(key);  // pobierz element listy
      return theLink;                // zwr element listy
      }
// -------------------------------------------------------------
   }  // end class HashTable
////////////////////////////////////////////////////////////////
class HashChainApp
   {
   public static void main(String[] args) throws IOException
      {
      int aKey;
      Link aDataItem;
      int size, n, keysPerCell = 100;
                                     // pobierz rozmiary
      System.out.print("Wprowad rozmiar tablicy rozproszonej: ");
      size = getInt();
      System.out.print("Wprowad pocztkow liczb elementw: ");
      n = getInt();
                                     // utwrz tablic
      HashTable theHashTable = new HashTable(size);

      for(int j=0; j<n; j++)         // wstaw dane
         {
         aKey = (int)(java.lang.Math.random() *
                                          keysPerCell * size);
         aDataItem = new Link(aKey);
         theHashTable.insert(aDataItem);
         }
      while(true)                    // interakcje z uytkownikiem
         {
         System.out.print("Wprowad pierwsz liter  ");
         System.out.print("Poka, Wstaw, Usu, or Znajd: ");
         char choice = getChar();
         switch(choice)
            {
            case 'p':
               theHashTable.displayTable();
               break;
            case 'w':
               System.out.print("Wprowad warto klucza: ");
               aKey = getInt();
               aDataItem = new Link(aKey);
               theHashTable.insert(aDataItem);
               break;
            case 'u':
               System.out.print("Wprowad warto klucza: ");
               aKey = getInt();
               theHashTable.delete(aKey);
               break;
            case 'z':
               System.out.print("Wprowad warto klucza: ");
               aKey = getInt();
               aDataItem = theHashTable.find(aKey);
               if(aDataItem != null)
                  System.out.println("Znaleziono " + aKey);
               else
                  System.out.println("Nie znaleziono " + aKey);
               break;
            default:
               System.out.print("Wcisne niewaciwy klawisz\n");
            }  // end switch
         }  // end while
      }  // end main()
//--------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//-------------------------------------------------------------
   public static char getChar() throws IOException
      {
      String s = getString();
      return s.charAt(0);
      }
//-------------------------------------------------------------
   public static int getInt() throws IOException
      {
      String s = getString();
      return Integer.parseInt(s);
      }
//--------------------------------------------------------------
   }  // end class HashChainApp
////////////////////////////////////////////////////////////////
